/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.bot.module;

import net.comp_lot.craftalos.bot.Bot;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.model.utils.RayCast;
import net.comp_lot.glui.system.OperationEvent;

public class ShootBot
extends Bot {
    private final double speed;
    private final boolean predict;
    private final double fireDistance;
    private final MutVector buf = new MutVector();
    private Model target;
    private Vector oldTargetPos;
    private Vector oldMyPos;
    private final MutVector move = new MutVector();

    public ShootBot(Bot bot, double speed, boolean predict, double fireDistance) {
        super(bot);
        this.speed = speed;
        this.predict = predict;
        this.fireDistance = fireDistance;
    }

    public void setTarget(Model target) {
        if (this.target != target) {
            this.target = target;
            this.oldTargetPos = null;
            this.move.set(Vector.ZERO);
        }
    }

    @Override
    protected void update(OperationEvent.KeyState key, MutVector camera) {
        key.setKey(OperationEvent.KeyCode.MOUSE_LEFT, false);
        key.setKey(OperationEvent.KeyCode.MOUSE_RIGHT, false);
        if (this.target != null && this.target.getBound().exist()) {
            Vector targetPos = ShootBot.getPos(this.target);
            Vector myPos = this.getSelfPos();
            if (this.predict && this.oldTargetPos != null && Math.random() < 0.05) {
                this.move.set(this.oldTargetPos, targetPos).add(myPos, -0.5).add(this.oldMyPos, 0.5);
            }
            this.oldTargetPos = targetPos;
            this.oldMyPos = myPos;
            Bound bound = this.target.getBound();
            double x = bound.getMinX();
            double X = bound.getMaxX();
            double y = bound.getMinY();
            double Y = bound.getMaxY();
            double z = bound.getMinZ();
            double Z = bound.getMaxZ();
            Vector[] vectors = new Vector[]{targetPos, new MutVector().set(x, Y, z).add(targetPos).scale(0.5), new MutVector().set(x, Y, Z).add(targetPos).scale(0.5), new MutVector().set(X, Y, z).add(targetPos).scale(0.5), new MutVector().set(X, Y, Z).add(targetPos).scale(0.5), new MutVector().set(x, y, z).add(targetPos).scale(0.5), new MutVector().set(x, y, Z).add(targetPos).scale(0.5), new MutVector().set(X, y, z).add(targetPos).scale(0.5), new MutVector().set(X, y, Z).add(targetPos).scale(0.5)};
            MutVector selfPos = new MutVector().set(myPos).add(Vector.Y_AXIS, this.getSelf().getBound().getHeight() * 0.25);
            Vector[] vectorArray = vectors;
            int n = vectors.length;
            int n2 = 0;
            while (n2 < n) {
                boolean fire;
                Vector p = vectorArray[n2];
                MutVector dist = new MutVector().set(selfPos, p);
                boolean bl = fire = dist.getSize() <= this.fireDistance && new RayCast(selfPos, dist, dist.getSize()).cast(this.getMap()) == null;
                if (this.predict) {
                    dist.add(this.move, dist.getSize() / this.speed * 0.2);
                }
                dist.add(Vector.Y_AXIS, dist.getSize() * dist.getSize() * 7.0E-4 / (this.speed * this.speed));
                dist.resize(1.0);
                this.buf.add(dist).resize(1.0);
                camera.set(this.buf);
                if (fire) {
                    key.setKey(OperationEvent.KeyCode.MOUSE_LEFT, true);
                    key.setKey(OperationEvent.KeyCode.MOUSE_RIGHT, true);
                    break;
                }
                ++n2;
            }
        }
    }
}

