/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.bot.module;

import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import net.comp_lot.craftalos.bot.module.Navigation;
import net.comp_lot.glui.amount.Vector;

public class NavigationRouter {
    private final Queue<Point> open = new PriorityQueue<Point>();
    private final Set<Navigation.WayPoint> close = new HashSet<Navigation.WayPoint>();

    public void search(Navigation.WayPoint start, Navigation.WayPoint end, double max, List<Vector> rtn) {
        this.open.clear();
        this.close.clear();
        this.open.add(new Point(0.0, start.getDist(end), start, null));
        Point last = null;
        while (!this.open.isEmpty()) {
            Point p = this.open.poll();
            if (this.close.contains(p.p)) continue;
            if (p.p == end) {
                last = p;
                break;
            }
            if (p.g + p.h > max) {
                return;
            }
            for (Navigation.WayPoint wp : p.p.getLink()) {
                if (this.close.contains(wp)) continue;
                this.open.add(new Point(p.g + p.p.getDist(wp) * NavigationRouter.getCost(wp), wp.getDist(end), wp, p));
            }
            this.close.add(p.p);
        }
        while (last != null) {
            rtn.add(last.p.getPos());
            last = last.before;
        }
    }

    private static double getCost(Navigation.WayPoint wp) {
        return wp.getScore();
    }

    private static class Point
    implements Comparable<Point> {
        private final double g;
        private final double h;
        private final Navigation.WayPoint p;
        private final Point before;

        Point(double g, double h, Navigation.WayPoint p, Point before) {
            this.g = g;
            this.h = h;
            this.p = p;
            this.before = before;
        }

        @Override
        public int compareTo(Point o) {
            return Double.compare(this.g + this.h, o.g + o.h);
        }
    }
}

