/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.bot.module;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.bot.module.NavigationRouter;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.model.utils.RayCast;
import net.comp_lot.glui.system.utils.FileUtils;

public class Navigation {
    private static final int[][] NEAR;
    private static final int SCALE = 16;
    private static final double HEIGHT_SCALE = 0.25;
    private static final double RAY_HEIGHT = 2.0;
    private static final Vector RAY;
    private final NavigationRouter nav = new NavigationRouter();
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;
    private final int minZ;
    private final int maxZ;
    private final Place[][] places;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{-1, 1};
        nArrayArray[3] = new int[]{1, 1};
        NEAR = nArrayArray;
        RAY = new MutVector().set(0.0, -1.0, 0.0);
    }

    public Navigation(Model map) {
        Bound b = map.getBound();
        this.minX = (int)b.getMinX();
        this.maxX = (int)b.getMaxX();
        this.minY = (int)b.getMinY();
        this.maxY = (int)b.getMaxY();
        this.minZ = (int)b.getMinZ();
        this.maxZ = (int)b.getMaxZ();
        this.places = new Place[(this.maxX - this.minX) / 16][(this.maxZ - this.minZ) / 16];
        int i = 0;
        while (i < this.places.length) {
            int x = this.minX + i * 16;
            int j = 0;
            while (j < this.places[i].length) {
                int z = this.minZ + j * 16;
                this.places[i][j] = new Place();
                double y = this.maxY - 1;
                while (y >= (double)(this.minY + 16)) {
                    RayCast cast = new RayCast(new MutVector().set(x, y, z), RAY, y - (double)this.minY - 1.0);
                    RayCast.CastResult r = cast.cast(map);
                    if (r != null) {
                        if (r.dist > 16.0 && Vector.Dot(r.getNormal(), RAY) < -0.5) {
                            this.places[i][j].addPoint(new WayPoint(new MutVector().set(r.point).add(RAY, -8.0)));
                        }
                        y = r.point.getY() - 1.0;
                        continue;
                    }
                    y = this.minY;
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < this.places.length - 1) {
            int j = 0;
            while (j < this.places[i].length - 1) {
                for (WayPoint p2 : this.places[i][j].getPoints()) {
                    int[][] nArray = NEAR;
                    int n = NEAR.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int[] d = nArray[n2];
                        WayPoint nearest = this.places[i + d[0]][j + d[1]].getNearest(p2.getPos());
                        if (nearest != null && Navigation.isPassable(map, p2.getPos(), nearest.getPos())) {
                            p2.addLink(nearest);
                            nearest.addLink(p2);
                        }
                        ++n2;
                    }
                }
                ++j;
            }
            ++i;
        }
        ArrayList<WayPoint> remove = new ArrayList<WayPoint>();
        int i2 = 0;
        while (i2 < this.places.length - 1) {
            int j = 0;
            while (j < this.places[i2].length - 1) {
                for (WayPoint p3 : this.places[i2][j].getPoints()) {
                    if (p3.getLinkNum(1) >= 6) continue;
                    remove.add(p3);
                }
                ++j;
            }
            ++i2;
        }
        remove.stream().forEach(p -> p.removeIncomingLink());
        i2 = 0;
        while (i2 < this.places.length - 1) {
            int j = 0;
            while (j < this.places[i2].length - 1) {
                for (WayPoint p4 : this.places[i2][j].getPoints()) {
                    p4.calcScore();
                }
                ++j;
            }
            ++i2;
        }
    }

    private static boolean isPassable(Model map, Vector sp, Vector dp) {
        MutVector ray;
        MutVector mutVector = new MutVector();
        if (Math.abs(sp.getY() - dp.getY()) > mutVector.set(sp, dp).getSize() * 0.25) {
            return false;
        }
        MutVector rayStart = new MutVector().set(sp).add(Vector.Y_AXIS, 2.0);
        return new RayCast(rayStart, ray = new MutVector().set(dp).add(Vector.Y_AXIS, 2.0).add(rayStart, -1.0), ((Vector)ray).getSize()).cast(map) == null;
    }

    public List<Vector> getRoute(Vector start, Vector end) {
        ArrayList<Vector> rtn = new ArrayList<Vector>();
        WayPoint s = this.getNearestWayPoint(start);
        WayPoint e = this.getNearestWayPoint(end);
        if (s == null || e == null) {
            rtn.add(end);
            return rtn;
        }
        this.nav.search(s, e, (this.maxX - this.minX + this.maxZ - this.minZ) * 2, rtn);
        if (rtn.isEmpty()) {
            rtn.add(end);
        }
        return rtn;
    }

    private WayPoint getNearestWayPoint(Vector position) {
        int xi = (int)((position.getX() - (double)this.minX + 8.0) / 16.0);
        int zi = (int)((position.getZ() - (double)this.minZ + 8.0) / 16.0);
        WayPoint rtn = null;
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                WayPoint p;
                if (xi + i >= 0 && xi + i < this.places.length && zi + j >= 0 && zi + j < this.places[0].length && (p = this.places[xi + i][zi + j].getNearest(position)) != null && (rtn == null || p.getDist(position) < rtn.getDist(position))) {
                    rtn = p;
                }
                ++j;
            }
            ++i;
        }
        return rtn;
    }

    public void writeMap(Vector start, Vector end) {
        StringBuilder sb = new StringBuilder();
        sb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" " + String.format("height=\"%d\" width=\"%d\" viewBox=\"0 0 %d %d\" ", this.maxX - this.minX, this.maxZ - this.minZ, this.maxX - this.minX, this.maxZ - this.minZ) + "class=\"SvgFrame\">\n");
        int i = 0;
        while (i < this.places.length - 1) {
            int j = 0;
            while (j < this.places[i].length - 1) {
                for (WayPoint p : this.places[i][j].getPoints()) {
                    for (WayPoint wp : p.getLink()) {
                        sb.append(String.format("<path d=\"M %.1f %.1f L %.1f %.1f\" stroke=\"#000000\"/>\n", p.getPos().getX() - (double)this.minX, p.getPos().getZ() - (double)this.minZ, wp.getPos().getX() - (double)this.minX, wp.getPos().getZ() - (double)this.minZ));
                    }
                }
                ++j;
            }
            ++i;
        }
        List<Vector> route = this.getRoute(start, end);
        int i2 = 1;
        while (i2 < route.size()) {
            sb.append(String.format("<path d=\"M %.1f %.1f L %.1f %.1f\" stroke=\"#ff0000\" stroke-width=\"5\"/>\n", route.get(i2 - 1).getX() - (double)this.minX, route.get(i2 - 1).getZ() - (double)this.minZ, route.get(i2).getX() - (double)this.minX, route.get(i2).getZ() - (double)this.minZ));
            ++i2;
        }
        sb.append("</svg>");
        FileUtils.writeFile("test.svg", sb.toString());
    }

    private static class Place {
        private final List<WayPoint> points = new ArrayList<WayPoint>();

        private Place() {
        }

        void addPoint(WayPoint p) {
            this.points.add(p);
        }

        WayPoint getNearest(Vector p) {
            return this.points.stream().sorted((a, b) -> Double.compare(a.getDist(p), b.getDist(p))).findFirst().orElse(null);
        }

        List<WayPoint> getPoints() {
            return this.points;
        }
    }

    static class WayPoint {
        private final Vector pos;
        private final List<WayPoint> link = new ArrayList<WayPoint>();
        private double score;

        private WayPoint(Vector pos) {
            this.pos = pos;
        }

        Vector getPos() {
            return this.pos;
        }

        double getDist(WayPoint p) {
            return this.getDist(p.getPos());
        }

        private double getDist(Vector v) {
            return Math.sqrt(this.pos.getDistS(v));
        }

        private void removeIncomingLink() {
            this.link.forEach(p -> p.removeLink(this));
        }

        private void addLink(WayPoint p) {
            this.link.add(p);
        }

        private void removeLink(WayPoint p) {
            this.link.remove(p);
        }

        private int getLinkNum(int depth) {
            if (depth == 1) {
                return this.link.size();
            }
            return this.link.stream().map(p -> p.getLinkNum(depth - 1)).reduce(0, (a, b) -> a + b);
        }

        List<WayPoint> getLink() {
            return this.link;
        }

        private void calcScore() {
            this.score = 512.0 / (double)this.getLinkNum(3);
        }

        double getScore() {
            return this.score;
        }
    }
}

