/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.bot.module;

import java.util.List;
import net.comp_lot.craftalos.bot.Bot;
import net.comp_lot.craftalos.bot.module.Navigation;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.system.OperationEvent;

public class MoveBot
extends Bot {
    private final double targetDistance;
    private final Navigation nav;
    private Vector targetPos;
    private boolean fire;
    private Vector v0;
    private Vector v1;
    private Vector v2;
    private Vector v3;

    public MoveBot(Bot bot, double targetDistance) {
        super(bot);
        this.targetDistance = targetDistance;
        this.nav = new Navigation(this.getMap());
    }

    public void setTarget(Vector targetPos, boolean fire) {
        if (targetPos != null) {
            this.targetPos = targetPos;
        }
        this.fire = fire;
        this.reroute();
    }

    private void reroute() {
        if (this.targetPos == null) {
            this.v0 = null;
            this.v1 = null;
            this.v2 = null;
            this.v3 = null;
            return;
        }
        Vector selfPos = this.getSelfPos();
        double dist = new MutVector().set(selfPos, this.targetPos).getSize();
        List<Vector> route = null;
        route = !this.fire || dist > this.targetDistance * 1.25 ? this.nav.getRoute(selfPos, this.targetPos) : this.getOrbitRoute(selfPos);
        if (route != null) {
            while (route.size() < 4) {
                route.add(0, route.get(0));
            }
            this.v0 = route.get(route.size() - 1);
            this.v1 = route.get(route.size() - 2);
            this.v2 = route.get(route.size() - 3);
            this.v3 = route.get(route.size() - 4);
        } else {
            this.v0 = null;
            this.v1 = null;
            this.v2 = null;
            this.v3 = null;
        }
    }

    private List<Vector> getOrbitRoute(Vector selfPos) {
        List<Vector> route;
        MutVector v = new MutVector().set(this.targetPos, selfPos).toOrthogonal(Vector.Y_AXIS).resize(this.targetDistance);
        MutVector t1 = new MutVector().set(v).rotate(Vector.Y_AXIS, 0.17453292519943295).add(this.targetPos);
        MutVector t2 = new MutVector().set(v).rotate(Vector.Y_AXIS, -0.17453292519943295).add(this.targetPos);
        List<Vector> r1 = this.nav.getRoute(selfPos, t1);
        List<Vector> r2 = this.nav.getRoute(selfPos, t2);
        if ((double)r1.size() * 1.5 < (double)r2.size()) {
            route = r1;
        } else if ((double)r2.size() * 1.5 < (double)r1.size()) {
            route = r2;
        } else {
            MutVector selfAxis = this.getGlobal(Vector.Z_AXIS);
            route = Vector.Dot(selfAxis, new MutVector().set(selfPos, t1)) > Vector.Dot(selfAxis, new MutVector().set(selfPos, t2)) ? r1 : r2;
        }
        return route;
    }

    @Override
    protected void update(OperationEvent.KeyState key, MutVector camera) {
        MutVector top = this.getGlobal(Vector.Y_AXIS);
        Vector selfPos = this.getSelfPos();
        MutVector selfAxis = this.getGlobal(Vector.Z_AXIS);
        if (this.v0 != null && selfPos.getDistS(this.v0) > selfPos.getDistS(this.v2)) {
            this.reroute();
        }
        if (this.v0 != null) {
            MutVector nextPos = MutVector.iDivision(this.v2, this.v3, Math.sqrt(selfPos.getDistS(this.v0)), Math.sqrt(selfPos.getDistS(this.v1)));
            MutVector move = new MutVector().set(selfPos, nextPos);
            double angle = Vector.angle(selfAxis, move, top);
            key.setKey(OperationEvent.KeyCode.KEY_D, angle > 0.3);
            key.setKey(OperationEvent.KeyCode.KEY_A, angle < -0.3);
            key.setKey(OperationEvent.KeyCode.KEY_W, Math.abs(angle) < 0.6 + Math.random() * 0.4);
        } else {
            key.setKey(OperationEvent.KeyCode.KEY_D, false);
            key.setKey(OperationEvent.KeyCode.KEY_A, false);
            key.setKey(OperationEvent.KeyCode.KEY_W, false);
        }
    }
}

