/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.bot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.system.OperationEvent;

public abstract class Bot {
    private final OperationEvent.KeyState key;
    private final MutVector camera;
    private final Model self;
    private final Model map;
    private final Collection<Model> enemies;
    private final Collection<Model> friends;

    public Bot(Model self, Model map) {
        this.self = self;
        this.map = map;
        this.key = new OperationEvent.KeyState();
        this.camera = new MutVector().set(Vector.Z_AXIS);
        this.enemies = new ArrayList<Model>();
        this.friends = new ArrayList<Model>();
    }

    public Bot(Bot bot) {
        this.self = bot.self;
        this.map = bot.map;
        this.key = bot.key;
        this.camera = bot.camera;
        this.enemies = bot.enemies;
        this.friends = bot.friends;
    }

    public final void update() {
        this.update(this.key, this.camera);
    }

    public OperationEvent.KeyState getKeyState() {
        return this.key;
    }

    public Vector getCamera() {
        return this.camera;
    }

    public void clearEnemy() {
        this.enemies.clear();
    }

    public void addEnemy(Model model) {
        this.enemies.add(model);
    }

    public void removeEnemy(Model model) {
        this.enemies.remove(model);
    }

    public void clearFriend() {
        this.friends.clear();
    }

    public void addFriend(Model model) {
        this.friends.add(model);
    }

    public void removeFriend(Model model) {
        this.friends.remove(model);
    }

    public void setParameter(String name, double value) {
        System.err.println("[Bot Error] : " + this.getClass().getSimpleName() + " has no parameter \"" + name + "\"");
    }

    protected abstract void update(OperationEvent.KeyState var1, MutVector var2);

    protected Model getMap() {
        return this.map;
    }

    protected Model getSelf() {
        return this.self;
    }

    protected Collection<Model> getEnemies() {
        return this.enemies.stream().filter(m -> m.getBound().exist()).collect(Collectors.toList());
    }

    protected Collection<Model> getFriends() {
        return this.friends.stream().filter(m -> m.getBound().exist()).collect(Collectors.toList());
    }

    protected MutVector getGlobal(Vector local) {
        MutVector rtn = new MutVector();
        ((ModelGroup)this.getSelf()).getAllChildren().get(0).LocalToGlobal(rtn, local);
        return rtn;
    }

    protected Vector getSelfPos() {
        return Bot.getPos(this.getSelf());
    }

    protected MutVector getDistance(Model model) {
        return new MutVector().set(this.getSelfPos(), Bot.getPos(model));
    }

    protected Model getNearest(Collection<Model> models) {
        return Bot.getNearest(this.getSelfPos(), models);
    }

    protected Model getNearestEnemy() {
        return this.getNearest(this.getEnemies());
    }

    protected static Vector getPos(Model model) {
        return model.getBound().getCenter();
    }

    protected static Model getNearest(Vector pos, Collection<Model> models) {
        return models.parallelStream().sorted((a, b) -> Double.compare(pos.getDistS(Bot.getPos(a)), pos.getDistS(Bot.getPos(b)))).findFirst().orElse(null);
    }
}

