/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.bot;

import net.comp_lot.craftalos.bot.Bot;
import net.comp_lot.craftalos.bot.module.ShootBot;
import net.comp_lot.craftalos.bot.module.TargetManager;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.system.OperationEvent;

public class AirBattleBot
extends Bot {
    private static final double FORGET_DISTANCE = 2100.0;
    private static final double FIND_DISTANCE = 2000.0;
    private final TargetManager target;
    private final ShootBot shoot;
    private MutVector targetPos = new MutVector();
    private Model nearest = null;
    private Vector nearestPos = null;
    private boolean up = false;

    public AirBattleBot(Model self, Model map) {
        super(self, map);
        this.shoot = new ShootBot(this, 2.9, true, 300.0);
        this.target = new TargetManager(this, 2000.0, 2100.0);
    }

    @Override
    public void setParameter(String name, double value) {
        switch (name) {
            case "target_x": {
                this.targetPos.set(value, this.targetPos.getY(), this.targetPos.getZ());
                break;
            }
            case "target_y": {
                this.targetPos.set(this.targetPos.getX(), value, this.targetPos.getZ());
                break;
            }
            case "target_z": {
                this.targetPos.set(this.targetPos.getX(), this.targetPos.getY(), value);
                break;
            }
            default: {
                super.setParameter(name, value);
            }
        }
    }

    @Override
    protected void update(OperationEvent.KeyState key, MutVector camera) {
        Model n;
        if (Math.random() < 0.1) {
            this.target.update();
            this.shoot.setTarget(this.target.getTarget());
        }
        this.shoot.update();
        if (this.targetPos.getY() - this.getSelfPos().getY() > 100.0 || this.targetPos.getY() - this.getSelfPos().getY() < -100.0 || this.targetPos.getY() - this.getSelfPos().getY() - camera.getY() * 50.0 > 100.0) {
            this.up = true;
        }
        if (this.targetPos.getY() - this.getSelfPos().getY() < 50.0 && this.targetPos.getY() - this.getSelfPos().getY() > -50.0) {
            this.up = false;
        }
        if (this.targetPos.getDistS(this.getSelfPos()) > 6250000.0) {
            this.up = true;
        }
        MutVector dir = this.getGlobal(Vector.Z_AXIS);
        if (this.up && (this.targetPos.getY() - this.getSelfPos().getY()) * camera.getY() < 0.0 || !this.target.hasTarget() || Vector.Dot(dir, camera) < -0.25) {
            camera.set(this.getSelfPos(), this.targetPos).resize(2.0).add(dir).resize(1.0);
            key.setKey(OperationEvent.KeyCode.MOUSE_LEFT, false);
        }
        key.setKey(OperationEvent.KeyCode.KEY_W, !key.isPressed(OperationEvent.KeyCode.MOUSE_LEFT) || this.target.hasTarget() && this.getDistance(this.target.getTarget()).getSize() > 200.0);
        if (Math.abs(camera.getY()) > 0.1) {
            camera.set(camera.getX(), Math.signum(camera.getY()) * (0.1 + (Math.abs(camera.getY()) - 0.1) * 0.5), camera.getZ()).resize(1.0);
        }
        Model ne = this.getNearest(this.getEnemies());
        Model nf = this.getNearest(this.getFriends());
        Model model = ne == null ? nf : (nf == null ? ne : (n = this.getDistance(ne).getSize() < this.getDistance(nf).getSize() ? ne : nf));
        if (n != null) {
            Vector p = AirBattleBot.getPos(n);
            MutVector distance = new MutVector().set(this.getSelfPos(), p);
            MutVector speed = new MutVector();
            if (this.nearest == n) {
                speed.set(this.nearestPos, p);
            }
            this.nearest = n;
            this.nearestPos = p;
            if (distance.getSize() < 300.0 && Vector.Dot(speed, dir) < -1.5 && Vector.Dot(distance, dir) / distance.getSize() > 0.5) {
                camera.set(dir).add(distance.toOrthogonal(dir).resize(-0.25)).resize(1.0);
            } else if (distance.getSize() < 200.0 && Vector.Dot(speed, dir) < 3.5 && Vector.Dot(distance, dir) / distance.getSize() > 0.25) {
                camera.set(dir).add(distance.toOrthogonal(dir).resize(-0.2)).resize(1.0);
            } else if (distance.getSize() < 100.0 && Vector.Dot(distance, dir) / distance.getSize() > 0.1) {
                camera.set(dir).add(distance.toOrthogonal(dir).resize(-0.15)).resize(1.0);
            } else if (distance.getSize() < 50.0) {
                camera.set(dir).add(distance.toOrthogonal(dir).resize(-0.1)).resize(1.0);
            }
        }
    }
}

