/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.mission.MissionResult;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.craftalos.system.network.server.GameServerClient;
import net.comp_lot.craftalos.system.network.server.LobbyServer;
import net.comp_lot.craftalos.system.start.StartMode;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.glui.display_lwjgl.GLMain;
import net.comp_lot.glui.sound.AudioSystem;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GluiApplication;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.glui.system.utils.TextureLoader;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.NineSliceImage;
import net.comp_lot.ui.core.DisplayInfo;

public class Main {
    private static final CraftalosConfig CONFIG = new CraftalosConfig();
    private static Mode mode = Mode.TITLE;
    public static String certFile;
    public static char[] certPass;
    public static String room;
    public static String missionID;
    public static String returnMessage;
    public static MissionResult missionResult;

    public static void reset() {
        room = "auto";
        missionID = null;
        returnMessage = null;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-v")) {
            System.out.println("Craftalos \u03b21.5.0");
            return;
        }
        if (args.length % 2 != 0) {
            System.out.print("-----------------------------------------------------\nusage:\n-----------------------------------------------------\n -m       mode select\n          [title, host, server, hostServer]\n -a       address\n -p       port\n -r       room\n -f       machine name\n -map     map\n -s       UI scale\n -pub     is public\n          [true, false]\n-----------------------------------------------------\n -v       show version\n-----------------------------------------------------\n");
            return;
        }
        GluiApplication application = new GluiApplication(CONFIG);
        StringManager.loadLang(CONFIG);
        Main.reset();
        RoomConfig roomConfig = new RoomConfig();
        String address = null;
        int port = 0;
        boolean ssl = false;
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            String value = args[i + 1];
            switch (opt) {
                case "-m": {
                    if (Main.setMode(value)) break;
                    return;
                }
                case "-a": {
                    address = value;
                    break;
                }
                case "-p": {
                    port = Integer.parseInt(value);
                    break;
                }
                case "-f": {
                    CONFIG.setFileName(value);
                    break;
                }
                case "-map": {
                    roomConfig.setMap(value, value);
                    break;
                }
                case "-r": {
                    room = value;
                    break;
                }
                case "-s": {
                    CONFIG.setUiScale(Double.parseDouble(value));
                    break;
                }
                case "-pub": {
                    roomConfig.setIsPublic(Boolean.parseBoolean(value) ? "public" : "private");
                    break;
                }
                case "-ssl": {
                    ssl = Boolean.parseBoolean(value);
                    break;
                }
                case "-certFile": {
                    certFile = value;
                    break;
                }
                case "-certPass": {
                    certPass = value.toCharArray();
                    break;
                }
                default: {
                    System.err.println("unknown option: '" + opt + "'");
                    return;
                }
                case "-os": 
            }
            i += 2;
        }
        if (mode == Mode.TITLE) {
            BufferedImage tex;
            File machineDir = new File("machine");
            if (!machineDir.exists()) {
                machineDir.mkdir();
            }
            try {
                tex = ImageIO.read(new File(FileUtils.APP_DIR + "res/img/tex.png"));
            }
            catch (IOException e) {
                System.err.println("\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f");
                System.exit(0);
                return;
            }
            MenuManager.setButtonFactory(display -> new ButtonLayout((DisplayInfo)display, TextureEnum.UI_BUTTON.getAsInfo(), 24));
            DialogBuilder.setBGFactory(display -> new NineSliceImage((DisplayInfo)display, TextureEnum.UI_WINDOW.getAsInfo(), 24, -1431633921));
            application.setTitle("Craftalos \u03b21.5.0").setIcon(Main.getIcon()).setTexture(TextureLoader.load(tex, CONFIG.getFontName())).setALUnit(0.02f).setFirstMode(game -> {
                Main.loadSounds(game.getAudioSystem());
                game.getRenderOptions().setTextureUnitSize(0, 128);
                return new StartMode((Game)game);
            }).launch();
        } else {
            if (mode == Mode.SERVER || mode == Mode.HOST_SERVER) {
                new LobbyServer(port, ssl, true);
            }
            if (mode == Mode.HOST || mode == Mode.HOST_SERVER) {
                new GameServerClient(roomConfig, address, port, ssl);
            }
        }
    }

    private static void loadSounds(AudioSystem audioSystem) {
        SoundEnum[] soundEnumArray = SoundEnum.values();
        int n = soundEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SoundEnum sound = soundEnumArray[n2];
            sound.setId(audioSystem.registerSound(((Object)((Object)sound)).getClass().getResourceAsStream(sound.getFile())));
            ++n2;
        }
    }

    private static BufferedImage getIcon() {
        try {
            return ImageIO.read(new File(FileUtils.APP_DIR + "res/img/icon.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean setMode(String value) {
        switch (value) {
            case "title": {
                mode = Mode.TITLE;
                break;
            }
            case "host": {
                mode = Mode.HOST;
                break;
            }
            case "server": {
                mode = Mode.SERVER;
                break;
            }
            case "hostServer": {
                mode = Mode.HOST_SERVER;
                break;
            }
            default: {
                System.out.println("unknown mode: '" + value + "'");
                return false;
            }
        }
        return true;
    }

    public static void exit() {
        GLMain.shouldExit = true;
    }

    public static enum Mode {
        TITLE,
        EDIT,
        PROGRAM,
        TEST,
        PLAY,
        JOIN,
        HOST_PLAY,
        CAMERA,
        HOST,
        SERVER,
        HOST_SERVER;

    }
}

