/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos;

import java.util.Locale;
import net.comp_lot.craftalos.EditModeKeyConfig;
import net.comp_lot.glui.system.GluiConfig;
import net.comp_lot.glui.system.OperationEvent;

public class CraftalosConfig
extends GluiConfig {
    public static final boolean PROTECT_SAMPLES = true;
    public static final String VERSION = "\u03b21.5.0";
    public static final int TEXTURE_UNIT_SIZE = 128;
    public static final String SERVER_NAME = "craftalos.comp-lot.net";
    public static final int SERVER_PORT = 51525;
    public static final int MAX_WEIGHT = 750;
    private float volumeBgm = 0.5f;
    private float volumeSe = 0.15f;
    private float volumeVoice = 0.5f;
    private String language = Locale.getDefault().getLanguage();
    private String fileName = "res/sample/simple_machine";
    private String playerName = String.format("Player %04d", (int)(Math.random() * 10000.0));
    private String localAddress = "";
    private int localPort = 51525;
    private float mouseSensitivity = 1.0f;
    private final EditModeKeyConfig editModeKeyConfig = new EditModeKeyConfig();

    @Override
    protected void saveParams(StringBuilder sb) {
        sb.append("[craftalos_config]\n");
        sb.append(String.format("volume_bgm=%.2f\n", Float.valueOf(this.getVolumeBgm())));
        sb.append(String.format("volume_se=%.2f\n", Float.valueOf(this.getVolumeSe())));
        sb.append(String.format("volume_voice=%.2f\n", Float.valueOf(this.getVolumeVoice())));
        sb.append(String.format("mouse_sensitivity=%.2f\n", Float.valueOf(this.getMouseSensitivity())));
        sb.append(String.format("language=%s\n", this.getLanguage()));
        if (this.getFileName() != null) {
            sb.append(String.format("fileName=%s\n", this.getFileName()));
        }
        sb.append(String.format("playerName=%s\n", this.getPlayerName()));
        sb.append(String.format("localAddress=%s\n", this.getLocalAddress()));
        sb.append(String.format("localPort=%d\n", this.getLocalPort()));
        sb.append("\n");
        this.editModeKeyConfig.getKeySet().stream().sorted().forEach(name -> {
            StringBuilder stringBuilder2 = sb.append(String.format("%s=%s\n", name, this.editModeKeyConfig.getKey((String)name).name()));
        });
        sb.append("\n");
        super.saveParams(sb);
    }

    @Override
    protected void loadParam(String param, String value) {
        if (param.startsWith("key_")) {
            this.editModeKeyConfig.setKey(param, Enum.valueOf(OperationEvent.KeyCode.class, value));
            return;
        }
        switch (param) {
            case "volume_bgm": {
                this.setVolumeBgm(Float.parseFloat(value));
                break;
            }
            case "volume_se": {
                this.setVolumeSe(Float.parseFloat(value));
                break;
            }
            case "volume_voice": {
                this.setVolumeVoice(Float.parseFloat(value));
                break;
            }
            case "mouse_sensitivity": {
                this.setMouseSensitivity(Float.parseFloat(value));
                break;
            }
            case "language": {
                this.setLanguage(value);
                break;
            }
            case "fileName": {
                this.setFileName(value);
                break;
            }
            case "playerName": {
                this.setPlayerName(value);
                break;
            }
            case "localAddress": {
                this.setLocalAddress(value);
                break;
            }
            case "localPort": {
                this.setLocalPort(Integer.parseInt(value));
                break;
            }
            default: {
                super.loadParam(param, value);
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    private void setPlayerName(String playerName) {
        if (playerName.matches("Player [0-9]{4}")) {
            this.playerName = playerName;
        } else {
            System.err.println("Invalid player name");
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public float getVolumeSe() {
        return this.volumeSe;
    }

    public void setVolumeSe(float volumeSe) {
        this.volumeSe = volumeSe;
    }

    public float getVolumeBgm() {
        return this.volumeBgm;
    }

    public void setVolumeBgm(float volumeBgm) {
        this.volumeBgm = volumeBgm;
    }

    public float getVolumeVoice() {
        return this.volumeVoice;
    }

    public void setVolumeVoice(float volumeVoice) {
        this.volumeVoice = volumeVoice;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public float getMouseSensitivity() {
        return this.mouseSensitivity;
    }

    public void setMouseSensitivity(float mouseSinsitivity) {
        this.mouseSensitivity = mouseSinsitivity;
    }

    public EditModeKeyConfig getEditModeKeyConfig() {
        return this.editModeKeyConfig;
    }
}

